function [pval stat] = indtest_new(X, Y, Z, pars)

if ~isfield(pars,'pairwise')
    pars.pairwise = false;
end;
if ~isfield(pars,'bonferroni')
    pars.bonferroni = false;
end;
if ~isfield(pars,'width')
    pars.width = 2;
end;

if size(X,2)>1||size(Y,2)>1
    % error('This test only works for one-dimensional random variables X and Y. Maybe it can be extended??')
    fprintf('Note that X and Y are random vectors.\n');
end

if isempty(Z) %unconditional HSIC
    if pars.pairwise
        p = zeros(size(X,2),size(Y,2));
        for i = 1:size(X,2);
            for j = 1:size(Y,2);
                [sta(i,j), Cri, p_vala, Cri_appr, p(i,j)] = UInd_KCItest(X(:,i), Y(:,j), pars.width);
            end
        end
        [pp iii] = min(p);
        [pval jj] = min(pp);
        stat = sta(iii(jj),jj);
        if pars.bonferroni
	        pval=size(X,2)*size(Y,2)*pval;
        end
    else
        [pval stat] = UInd_KCItest(X, Y, pars.width);
    end
else % conditional independence test
    [stat, Cri, p_val_appr, Cri_appr, pval] = CInd_test_new_withGP(X, Y, Z, 0.8, pars.width);
end

return



